/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.rei.display;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SequencedAssemblyDisplay(EntryIngredient input, SequenceData sequences, ProcessingOutput output, int loop, Optional<class_2960> location) implements Display
{
    public static final DisplaySerializer<SequencedAssemblyDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().fieldOf("input").forGetter(SequencedAssemblyDisplay::input), (App)SequenceData.CODEC.fieldOf("sequences").forGetter(SequencedAssemblyDisplay::sequences), (App)ProcessingOutput.CODEC.fieldOf("output").forGetter(SequencedAssemblyDisplay::output), (App)Codec.INT.fieldOf("loop").forGetter(SequencedAssemblyDisplay::loop), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(SequencedAssemblyDisplay::location)).apply((Applicative)instance, SequencedAssemblyDisplay::new)), (class_9139)class_9139.method_56906((class_9139)EntryIngredient.streamCodec(), SequencedAssemblyDisplay::input, SequenceData.PACKET_CODEC, SequencedAssemblyDisplay::sequences, ProcessingOutput.STREAM_CODEC, SequencedAssemblyDisplay::output, (class_9139)class_9135.field_49675, SequencedAssemblyDisplay::loop, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), SequencedAssemblyDisplay::location, SequencedAssemblyDisplay::new));

    public SequencedAssemblyDisplay(class_8786<SequencedAssemblyRecipe> entry) {
        this(entry.comp_1932().method_29177(), (SequencedAssemblyRecipe)entry.comp_1933());
    }

    public SequencedAssemblyDisplay(class_2960 id, SequencedAssemblyRecipe recipe) {
        this(EntryIngredients.ofIngredient((class_1856)recipe.ingredient()), SequenceData.create(recipe), recipe.result(), recipe.loops(), Optional.of(id));
    }

    public List<EntryIngredient> getInputEntries() {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        inputs.add(this.input);
        for (EntryIngredient ingredient : this.sequences.ingredients) {
            if (ingredient.isEmpty()) continue;
            inputs.add(ingredient);
        }
        return inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredients.of((class_1799)this.output.create()));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.SEQUENCED_ASSEMBLY;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public record SequenceData(List<class_3956<?>> types, List<List<class_2561>> tooltip, List<EntryIngredient> ingredients) {
        public static final Codec<SequenceData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)class_7923.field_41188.method_39673().listOf().fieldOf("types").forGetter(SequenceData::types), (App)class_8824.field_46597.listOf().listOf().fieldOf("tooltip").forGetter(SequenceData::tooltip), (App)EntryIngredient.codec().listOf().fieldOf("ingredients").forGetter(SequenceData::ingredients)).apply((Applicative)instance, SequenceData::new));
        public static final class_9139<class_9129, SequenceData> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.method_56365((class_5321)class_7924.field_41217).method_56433(class_9135.method_56363()), SequenceData::types, (class_9139)class_8824.field_49668.method_56433(class_9135.method_56363()).method_56433(class_9135.method_56363()), SequenceData::tooltip, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), SequenceData::ingredients, SequenceData::new);

        public static SequenceData create(SequencedAssemblyRecipe recipe) {
            ImmutableList.Builder ingredientBuilder = ImmutableList.builder();
            ImmutableList.Builder textBuilder = ImmutableList.builder();
            ImmutableList.Builder typeBuilder = ImmutableList.builder();
            List<class_1860<?>> recipes = recipe.sequence();
            int size = recipes.size() / recipe.loops();
            for (int i = 0; i < size; ++i) {
                class_1860<?> sequence = recipes.get(i);
                typeBuilder.add((Object)sequence.method_17716());
                ImmutableList.Builder tooltipBuilder = ImmutableList.builder();
                tooltipBuilder.add((Object)class_2561.method_43469((String)"create.recipe.assembly.step", (Object[])new Object[]{i + 1}));
                if (sequence instanceof DeployerApplicationRecipe) {
                    DeployerApplicationRecipe deployerApplicationRecipe = (DeployerApplicationRecipe)sequence;
                    tooltipBuilder.add((Object)class_2561.method_43469((String)"create.recipe.assembly.deploying_item", (Object[])new Object[]{""}).method_27692(class_124.field_1077));
                    ingredientBuilder.add((Object)EntryIngredients.ofIngredient((class_1856)deployerApplicationRecipe.ingredient()));
                } else if (sequence instanceof FillingRecipe) {
                    FillingRecipe fillingRecipe = (FillingRecipe)sequence;
                    tooltipBuilder.add((Object)class_2561.method_43469((String)"create.recipe.assembly.spout_filling_fluid", (Object[])new Object[]{""}).method_27692(class_124.field_1077));
                    ingredientBuilder.add((Object)IngredientHelper.createEntryIngredient(fillingRecipe.fluidIngredient()));
                } else {
                    ingredientBuilder.add((Object)EntryIngredient.empty());
                    class_2960 id = class_7923.field_41188.method_10221((Object)sequence.method_17716());
                    if (id != null) {
                        String namespace = id.method_12836();
                        Object recipeName = namespace.equals("create") ? id.method_12832() : id.method_12836() + "." + id.method_12832();
                        tooltipBuilder.add((Object)class_2561.method_43471((String)("create.recipe.assembly." + (String)recipeName)).method_27692(class_124.field_1077));
                    } else {
                        tooltipBuilder.add((Object)class_5244.field_39003);
                    }
                }
                textBuilder.add((Object)tooltipBuilder.build());
            }
            return new SequenceData((List<class_3956<?>>)typeBuilder.build(), (List<List<class_2561>>)textBuilder.build(), (List<EntryIngredient>)ingredientBuilder.build());
        }
    }
}

